﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.IO;

namespace PsgBase
{
    public partial class psgComboBoxEdit : UserControl
    {
        #region Fields / Contructors

        public object initial_value = string.Empty;
        string fileName = string.Empty;
        string valueKey = string.Empty;
        string fieldKey = string.Empty, cmFieldKey = string.Empty, cmFieldDisplay = string.Empty;
        string fieldName = string.Empty;
        string servertablename = string.Empty, comboCommand = string.Empty, comboServerTableName = string.Empty;
        string fieldType;
        bool notNull = false;
        DataTable psgCMTable;
        int hmn_loop;
        bool blocked;

        public psgComboBoxEdit()
        {
            InitializeComponent();
        }

        #endregion

        #region Properties

        [Category("PSG")]
        public string PsgFieldType
        {
            get { return fieldType; }
            set { fieldType = value; }
        }

        [Category("PSG")]
        public bool PsgNotNull
        {
            get { return notNull; }
            set { notNull = value; }
        }

        [Category("PSG")]
        public string PsgFieldName
        {
            get { return fieldName; }
            set
            {
                fieldName = value;
            }
        }

        [Category("PSG"), Browsable(false)]
        public DataTable PsgComboTable
        {
            get { return psgCMTable; }
            set { psgCMTable = value; }
        }

        [Category("PSG"), Browsable(false)]
        public string PsgValueKey
        {
            get { return valueKey; }
            set { valueKey = value; }
        }

        [Category("PSG")]
        public string PsgFieldKey
        {
            get { return fieldKey; }
            set { fieldKey = value; }
        }

        [Category("PSG")]
        public string PsgServerTableName
        {
            get { return servertablename; }
            set { servertablename = value; }
        }

        [Category("PSG")]
        public string PsgComboFieldKey
        {
            get { return cmFieldKey; }
            set { cmFieldKey = value; }
        }

        [Category("PSG")]
        public string PsgComboFieldDisplay
        {
            get { return cmFieldDisplay; }
            set { cmFieldDisplay = value; }
        }

        [Category("PSG")]
        public string PsgComboCommand
        {
            get { return comboCommand; }
            set { comboCommand = value; }
        }

        [Category("PSG")]
        public string PsgComboServerTableName
        {
            get { return comboServerTableName; }
            set { comboServerTableName = value; }
        }

        [Category("PSG")]
        public string PsgComboFileName
        {
            get { return fileName; }
            set { fileName = value; }
        }

        [Browsable(false)]
        public object DataSource
        {
            get { return cbEntity.DataSource; }
            set { cbEntity.DataSource = value; }
        }

        [Browsable(false)]
        public string DisplayMember
        {
            get { return cbEntity.DisplayMember; }
            set { cbEntity.DisplayMember = value; }
        }

        [Browsable(false)]
        public string ValueMember
        {
            get { return cbEntity.ValueMember; }
            set { cbEntity.ValueMember = value; }
        }

        [Browsable(false)]
        public object SelectedValue
        {
            get { return cbEntity.SelectedValue; }
            set { cbEntity.SelectedValue = value; }
        }

        [Browsable(false)]
        public Control Control
        {
            get { return cbEntity; }
        }

        #endregion

        private void btnEntity_Click(object sender, EventArgs e)
        {
            Context.Command = this.PsgComboCommand;
            Context.ServerTableName = this.PsgComboServerTableName; 
            Context.FileName = this.PsgComboFileName;

            this.initial_value = this.cbEntity.SelectedValue; 
            cmEntity.Show(new Point(Base.psgIntf.GetPositionInForm(btnEntity).X + btnEntity.Width + 5, Base.psgIntf.GetPositionInForm(btnEntity).Y));

            if (string.IsNullOrEmpty(this.PsgComboCommand) ||
                string.IsNullOrEmpty(this.PsgComboServerTableName) ||
                string.IsNullOrEmpty(this.PsgComboFieldDisplay) ||
                string.IsNullOrEmpty(this.PsgComboFieldKey) ||
                string.IsNullOrEmpty(this.PsgComboFileName) )
            {
                MessageBox.Show("PSG properties are not set. ", "Attention!");
                return;
            }

            string docName = Utils.GetFileName(this.PsgComboFileName);
            string fileName = this.PsgComboFileName;

            foreach (DataRow row in Base.psgIntf.documents.Rows)
            {
                if (row["docname"].ToString().ToLower() == docName.ToLower())
                {
                    if (!File.Exists(fileName))
                    {
                        Base.psgIntf.DownloadDetailes(fileName, row["id_code"].ToString());
                        cmEntity.Enabled = false;
                        Base.psgContextMenu = cmEntity;
                        Base.psgContextMenuFileName = this.PsgComboFileName;

                        Base.psgIntf.send_command("GETDOCUMENTEDIT#\"" + fileName + "\"");
                        Base.bDownloadDoc = true;
                        //Base.psgIntf.pDownloading.Visible = true;
                        //Thread.Sleep(300);
                        return;
                    }

                    if (!string.IsNullOrEmpty(fileName) && Utils.MD5File(fileName) != row["doccrc"].ToString())
                    {
                        Base.psgIntf.DownloadDetailes(fileName, row["id_code"].ToString());
                        cmEntity.Enabled = false;
                        Base.psgContextMenu = cmEntity;
                        Base.psgContextMenuFileName = this.PsgComboFileName;

                        Base.psgIntf.send_command("GETDOCUMENTEDIT#\"" + fileName + "\"");
                        Base.bDownloadDoc = true;
                        //Base.psgIntf.pDownloading.Visible = true;
                        //Thread.Sleep(300);
                        return;
                    }
                }
            }
        }

        private void mnAdd_Click(object sender, EventArgs e)
        {
            Base.bPopulateView = false;
            Base.bClosed = false;
            Base.bUpdateLastControl = false;

            Base.psgIntf.newID = Base.psgIntf.PsgGuid.ToLower().Trim();
            Base.psgIntf.psgInsert(Context.ServerTableName, this.PsgComboFieldKey, Base.psgIntf.newID, false);
            Base.psgIntf.SetCurrentPK(Context.ServerTableName, Base.psgIntf.newID);
            Base.psgIntf.LoadDocumentComboEdit(Context.FileName, "PsgStart", Base.psgIntf.newID, this.PsgComboFieldDisplay, this.PsgComboFieldKey, this.PsgComboTable, this);
        }

        private void mnModify_Click(object sender, EventArgs e)
        {
            Base.bPopulateView = false;
            Base.bClosed = false;
            Base.bUpdateLastControl = false;

            if (this.cbEntity.SelectedValue == null ||
                string.IsNullOrEmpty(this.cbEntity.SelectedValue.ToString()))
                return;

            string _keyValue = (this.cbEntity.SelectedValue == null) ? string.Empty : cbEntity.SelectedValue.ToString();
            Base.psgIntf.SetCurrentPK(Context.ServerTableName, _keyValue);
            Base.psgIntf.LoadDocumentComboEdit(Context.FileName, "PsgStart", _keyValue, this.PsgComboFieldDisplay, this.PsgComboFieldKey, this.PsgComboTable, this);
        }

        private void psgComboEdit_Validating(object sender, System.ComponentModel.CancelEventArgs e)
        {
            try
            {
                if (this.PsgNotNull && string.IsNullOrEmpty(((ComboBox)sender).Text))
                {
                    Base.psgIntf.ErrorProvider.SetError(this, Base.GetIntl(ConstantsBase.Field_is_required));
                }
                else
                    Base.psgIntf.ErrorProvider.SetError(this, string.Empty);
            }
            finally
            {
                Base.psgIntf.RefreshForm();
            }

            if (this.FindForm() is BaseEntity)
                return;

            if (string.IsNullOrEmpty(this.PsgServerTableName) ||
                   string.IsNullOrEmpty(this.PsgFieldKey) ||
                   string.IsNullOrEmpty(this.PsgFieldName) ||
                string.IsNullOrEmpty(this.PsgFieldType))
            {
                MessageBox.Show("PSG properties are not set. ", "Attention!");
                return;
            }


            psgUpdate(sender, Base.psgIntf.GetCurrentPK(this.PsgServerTableName));

            if (Intf.cmdResult == PsgMsg.NOK)
            {
                e.Cancel = true;
                Intf.cmdResult = PsgMsg.OK;
                return;
            }
        }

        private void psgComboEdit_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (this.FindForm() is BaseEntity)
                return;

            if (e.KeyChar == Convert.ToChar(13))
            {
                if (string.IsNullOrEmpty(this.PsgServerTableName) ||
                        string.IsNullOrEmpty(this.PsgFieldKey) ||
                        string.IsNullOrEmpty(this.PsgFieldName) ||
                        string.IsNullOrEmpty(this.PsgFieldType))
                {
                    MessageBox.Show("PSG properties are not set. ", "Attention!");
                    return;
                }

                psgUpdate(sender, Base.psgIntf.GetCurrentPK(this.PsgServerTableName));
                Base.bUpdate = false;
                SendKeys.Send("{TAB}");
                e.Handled = true;
            }
        }

        public void psgUpdate(object sender, string _id)
        {
            if (this.FindForm() is BaseEntity)
                return;

            if (Base.psgIntf == null)
                return;

            if (!string.IsNullOrEmpty(((ComboBox)sender).Text))
                this.cbEntity.SelectedIndex = this.cbEntity.FindStringExact(((ComboBox)sender).Text);

            if (this.cbEntity.SelectedIndex == -1)
            {
                ((ComboBox)sender).Text = string.Empty;
                ((ComboBox)sender).SelectedText = string.Empty;
                ((ComboBox)sender).SelectedValue = string.Empty;
            }
            if (!this.blocked && Base.bUpdate && 
                !Utils.StringEquals(((ComboBox)sender).SelectedValue, this.initial_value))
            {
                this.blocked = true;

                Base.kv = Base.GetParameters(_id, "C");
                Base.value = Base.GetParameters(this.cbEntity.SelectedValue, fieldType);
                Base.psgIntf.send_command("UPDATEFIELD#'" + this.PsgServerTableName + "','" + this.PsgFieldKey
                + "'," + Base.kv + ",'" + this.PsgFieldName + "'," + Base.value);

                CheckUpdate();
            }
        }

        public void psgUpdateCombo(object sender, string _id)
        {
            if (this.FindForm() is BaseEntity)
                return;

            if (!this.blocked && Base.bUpdate)
            {
                this.blocked = true;

                Base.kv = Base.GetParameters(_id, "C");
                Base.value = Base.GetParameters(Base.psgIntf.IsNull(this.cbEntity.SelectedValue, this.Text), fieldType);
                Base.psgIntf.send_command("UPDATEFIELD#'" + this.PsgServerTableName + "','" + this.PsgFieldKey
                + "'," + Base.kv + ",'" + this.PsgFieldName + "'," + Base.value);

                CheckUpdate();
            }
        }

        public void CheckUpdate()
        {
            hmn_loop = 0;
            while (Intf.cmdResult != "OK" && this.hmn_loop <= 200)
            {
                Thread.Sleep(30);
                this.hmn_loop = this.hmn_loop + 1;
            }

            if (Intf.cmdResult != "OK")
            {
                MessageBox.Show("Server communication failed. Check server connectivity and try again!", Base.GetIntl(ConstantsBase.Attention_), MessageBoxButtons.OK);
                this.SelectedValue = this.initial_value;
            }

            this.initial_value = this.SelectedValue;
            this.blocked = false;

            View view = ((Base)this.FindForm()).view;
            if (view != null && view is ViewGrid && view.bsEditor != null)
                view.bsEditor.EndEdit();
        }

        void psgComboEdit_Enter(object sender, EventArgs e)
        {
            cmEntity.Hide();
            this.initial_value = this.SelectedValue;
            Base.bUpdate = true;
        }

        private void psgComboEdit_Click(object sender, EventArgs e)
        {
            ((ComboBox)sender).DroppedDown = true;
        }

        private void cbEntity_TextChanged(object sender, EventArgs e)
        {
            if (!Base.bUpdate)
                return;

            if (this.PsgNotNull && string.IsNullOrEmpty(((ComboBox)sender).Text))
            {
                Base.psgIntf.ErrorProvider.SetError(this, Base.GetIntl(ConstantsBase.Field_is_required));
            }
            else
                Base.psgIntf.ErrorProvider.SetError(this, string.Empty);
        }
    }
}
